/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.util.Enumeration;
import java.util.Properties;
import org.exolab.castor.jdo.conf.DataSource;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.DatabaseChoice;
import org.exolab.castor.jdo.conf.Driver;
import org.exolab.castor.jdo.conf.JdoConf;
import org.exolab.castor.jdo.conf.Mapping;
import org.exolab.castor.jdo.conf.Param;
import org.exolab.castor.jdo.conf.TransactionDemarcation;

public class JdoConfFactory {
    public static Database createJdoDbConf(String name, String engine) {
        Database dbConf = new Database();
        dbConf.setName(name);
        dbConf.setEngine(engine);
        return dbConf;
    }

    public static Database createJdoDbConf(String db_name, String engine, DataSource dsConf) {
        Database dbConf = JdoConfFactory.createJdoDbConf(db_name, engine);
        DatabaseChoice dbChoice = new DatabaseChoice();
        dbChoice.setDataSource(dsConf);
        dbConf.setDatabaseChoice(dbChoice);
        return dbConf;
    }

    public static Database createJdoDbConf(String db_name, String engine, Driver driverConf) {
        Database dbConf = JdoConfFactory.createJdoDbConf(db_name, engine);
        DatabaseChoice dbChoice = new DatabaseChoice();
        dbChoice.setDriver(driverConf);
        dbConf.setDatabaseChoice(dbChoice);
        return dbConf;
    }

    public static JdoConf createJdoConf(Database jdoDbConf, TransactionDemarcation transConf) {
        return JdoConfFactory.createJdoConf(new Database[]{jdoDbConf}, transConf);
    }

    public static JdoConf createJdoConf(Database[] jdoDbConfArray, TransactionDemarcation transConf) {
        JdoConf jdoConf = new JdoConf();
        jdoConf.setDatabase(jdoDbConfArray);
        jdoConf.setTransactionDemarcation(transConf);
        return jdoConf;
    }

    public static JdoConf createJdoConf(Database jdoDbConf) {
        return JdoConfFactory.createJdoConf(new Database[]{jdoDbConf});
    }

    public static JdoConf createJdoConf(Database[] jdoDbConfArray) {
        JdoConf jdoConf = new JdoConf();
        jdoConf.setDatabase(jdoDbConfArray);
        jdoConf.setTransactionDemarcation(JdoConfFactory.createSimpleTransactionDemarcationConf());
        return jdoConf;
    }

    public static Driver createJdoDriverConf(String driver_name, String db_url, String username, String password) {
        Driver driverConf = new Driver();
        driverConf.setClassName(driver_name);
        driverConf.setUrl(db_url);
        driverConf.addParam(JdoConfFactory.createJdoConfParam("user", username));
        driverConf.addParam(JdoConfFactory.createJdoConfParam("password", password));
        return driverConf;
    }

    public static Param createJdoConfParam(String name, String value) {
        Param param = new Param();
        param.setName(name);
        param.setValue(value);
        return param;
    }

    public static DataSource createJdoDSConf(String dsClassName, Properties props) {
        DataSource dsConf = new DataSource();
        dsConf.setClassName(dsClassName);
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = props.get(key);
            dsConf.addParam(JdoConfFactory.createJdoConfParam(key.toString(), value.toString()));
        }
        return dsConf;
    }

    public static DataSource createJdoDSConf(String dsClassName) {
        DataSource dsConf = new DataSource();
        dsConf.setClassName(dsClassName);
        return dsConf;
    }

    public static Mapping createJdoMappingConf(String map_url) {
        Mapping mapConf = new Mapping();
        mapConf.setHref(map_url);
        return mapConf;
    }

    public static TransactionDemarcation createSimpleTransactionDemarcationConf() {
        TransactionDemarcation trans = new TransactionDemarcation();
        trans.setMode("local");
        return trans;
    }
}

